#include "General.h"
#include "RangeRoFDetection.h"
#include "weaponmgr.h"
#include "VehicleGameObjDef.h"
#include "gmlog.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

float HitAllowance = 0.1f;
int ThinkTime = 1;
int LastThink = 0;
int Time = (int)time(NULL);

PlayerWeaponData* PlayerData[128];

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

void DamageDone(int PlayerID, int VictimID)
{
	PlayerWeaponData* p = PlayerData[PlayerID];
	GameObject *Victim = Commands->Find_Object(VictimID);
	if (Get_GameObj(PlayerID) && Victim && !Get_Vehicle(Get_GameObj(PlayerID)))
	{
		p->Hits++;
		if (Is_C4(Victim))
		{
			GameObject *Attached = Get_C4_Attached(Victim);
			if (Attached && !Is_Building(Attached))
			{
				p->HitMultiplier = 2;
			}
		}
	}
}

void SpectateDetection(int PlayerID, int ObjID, int VictimID, int WarheadID, float Damage)
{
	GameObject *Damager = Commands->Find_Object(ObjID);
	GameObject *Victim = Commands->Find_Object(VictimID);

	if(Damager && Victim)
	{
		if (!Get_Vehicle(Damager))
		{
			char VictimName[128] = "something";
			int ExtraDistance = 30;
			if (Is_Vehicle(Victim) && Get_Vehicle_Mode(Victim) != VEHICLE_TYPE_TURRET)
			{
				ExtraDistance = 40;
				const char *VictimPreset = Get_Translated_Preset_Name(Victim);
				if (Get_Vehicle_Driver(Victim))
				{
					sprintf(VictimName, "%S's %s", Get_Wide_Player_Name(Get_Vehicle_Driver(Victim)), VictimPreset);
				}
				else
				{
					sprintf(VictimName, "a %s", VictimPreset);
				}
				delete []VictimPreset;
			}
			else if (Commands->Is_A_Star(Victim))
			{
				ExtraDistance = 20;
				sprintf(VictimName, "%S", Get_Wide_Player_Name(Victim));
			}
			const AmmoDefinitionClass *Ammo = Get_Weapon_Ammo_Definition(Get_Current_Weapon(Damager), true);
			float Distance = Commands->Get_Distance(Commands->Get_Position(Damager),Commands->Get_Position(Victim));

			if (((int)Ammo->Range + ExtraDistance) < Distance && WarheadID == (int)Ammo->Warhead)
			{
				char *WeaponName = (char *)WideCharToChar(Get_Current_Wide_Translated_Weapon(Damager));

				if (_stricmp("Repair Gun", WeaponName) == 0)
				{
					delete []WeaponName;
					return;
				}

				const char *DamagerNick = Get_Player_Name(Damager);

				PlayerWeaponData* p = PlayerData[PlayerID];
				Time = (int)time(NULL);
				if ((Time - p->LastRangeCheck) > ThinkTime)
				{
					Console_Output("[IRANSTUFF][Range Warning]%s (%s) attempted to attack %s from out of range. Distance: %.2f meters  Max Distance: %.2f meters.\n", DamagerNick, WeaponName, VictimName, Distance, (int)Ammo->Range);
//					SSGMGameLog::Log_RenLog(TT_FORMAT(1024, "[IRANSTUFF][Range Warning]%s (%s) attempted to attack %s from out of range. Distance: %.2f meters  Max Distance: %.2f meters.", DamagerNick, WeaponName, VictimName, Distance, (int)Ammo->Range));
					p->LastRangeCheck = Time;
				}
				delete []DamagerNick;
				delete []WeaponName;
			}
		}
	}
}

void Init_Weapon_Data_Player(int PlayerID)
{
	PlayerData[PlayerID]->CurrAmmo = 0;
	PlayerData[PlayerID]->CurrWeapon = 0;
	PlayerData[PlayerID]->HitMultiplier = 0;
	PlayerData[PlayerID]->Hits = 0;
	PlayerData[PlayerID]->LastActive = 0;
	PlayerData[PlayerID]->LastAmmo = 0;
	PlayerData[PlayerID]->LastWeapon = 0;
	PlayerData[PlayerID]->LastRangeCheck = 0;
}

RangeRoFDetection::RangeRoFDetection()
{
	RegisterEvent(EVENT_STOCK_DAMAGE_HOOK,this);
	RegisterEvent(EVENT_TT_DAMAGE_HOOK,this);
	RegisterEvent(EVENT_THINK_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);

	for( int i = 0; i < 127; i++)
	{
		PlayerData[i] = new PlayerWeaponData;
	}
}

RangeRoFDetection::~RangeRoFDetection()
{
	UnregisterEvent(EVENT_STOCK_DAMAGE_HOOK,this);
	UnregisterEvent(EVENT_TT_DAMAGE_HOOK,this);
	UnregisterEvent(EVENT_THINK_HOOK,this);
	UnregisterEvent(EVENT_PLAYER_LEAVE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void RangeRoFDetection::OnPlayerLeave(int PlayerID)
{
	Init_Weapon_Data_Player(PlayerID);
}

void RangeRoFDetection::OnLoadLevel()
{
	for (int i = 1; i < 127; i++)
	{
		Init_Weapon_Data_Player(i);
	}
}

bool RangeRoFDetection::OnTtDamage(PhysicalGameObj* damager, PhysicalGameObj* target, const AmmoDefinitionClass* ammo, const char* bone)
{
	if (!Commands->Is_A_Star((GameObject*)damager)) return true;

	DamageDone(Get_Player_ID((GameObject*)damager), Commands->Get_ID((GameObject*)target));
	SpectateDetection(Get_Player_ID((GameObject*)damager), Commands->Get_ID((GameObject*)damager), Commands->Get_ID((GameObject*)target),
		(int)ammo->Warhead, (float)ammo->Damage);

	return true;
}
bool RangeRoFDetection::OnStockDamage(PhysicalGameObj* damager, PhysicalGameObj* target, float damage, uint warheadId)
{
	if (!Commands->Is_A_Star((GameObject*)damager)) return true;

	DamageDone(Get_Player_ID((GameObject*)damager), Commands->Get_ID((GameObject*)target));
	SpectateDetection(Get_Player_ID((GameObject*)damager), Commands->Get_ID((GameObject*)damager), Commands->Get_ID((GameObject*)target),
		(int)warheadId, damage);

	return true;
}
// To add checking vehicle RoF, PlayerObj needs to be changed to CheckObj and Get_Vehicle_Return() needs to be called
// Change the code in DamageDone() to NOT check for vehicles
// Using Get_Current_Wide_Translated_Weapon() on a vehicle might cause a crash
void RangeRoFDetection::OnThink()
{
	Time = (int)time(NULL);
	if ((Time - LastThink) >= ThinkTime)
	{
		LastThink = Time;
		for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
		{
			cPlayer *cP = PlayerIter->Data();
			if (cP && cP->IsActive)
			{
				GameObject *PlayerObj = Get_GameObj(cP->PlayerId);

				if (Get_Current_Weapon(PlayerObj) == NULL) continue;

				PlayerWeaponData* p = PlayerData[cP->PlayerId];
				if (PlayerObj)
				{
					char *WeaponName = (char *)WideCharToChar(Get_Current_Wide_Translated_Weapon(PlayerObj));
					if (WeaponName && p->CurrWeapon && p->CurrAmmo && p->Hits > 0)
					{
						int MaxHits = -1;
						if ((int)p->CurrWeapon->ClipSize == 1)
						{
							MaxHits = (int)p->CurrAmmo->SprayCount;
						}
						else
						{
							MaxHits = (int)ceil((float)(int)p->CurrAmmo->SprayCount * p->CurrAmmo->RateOfFire);
						}
						
						int Allowance = (int)ceil((MaxHits * p->HitMultiplier) * HitAllowance);

						if ((_stricmp("Repair Gun", WeaponName) == 0) || (_stricmp("Flame Thrower", WeaponName) == 0) || (_stricmp("Chem Sprayer", WeaponName) == 0))
						{
							delete []WeaponName;
							return;
						} //Flame Thrower 60-70 Repair Gun 35-45
						if (p->Hits > ((MaxHits * p->HitMultiplier) + Allowance))
						{
							Console_Output("[IRANSTUFF][RoF Exceeded]Name: %S ID: %d Ping: %d Hits: %d HitMultiplier: %d DefHits: %d Allowance: %d MaxHits: %d Weapon: %s\n", cP->PlayerName, cP->PlayerId, cP->Ping, p->Hits, p->HitMultiplier, MaxHits, Allowance, ((MaxHits * p->HitMultiplier) + Allowance), WeaponName);
//							SSGMGameLog::Log_RenLog(TT_FORMAT(1024, "[IRANSTUFF][RoF Exceeded]Name: %S ID: %d Ping: %d Hits: %d HitMultiplier: %d DefHits: %d Allowance: %d MaxHits: %d Weapon: %s", cP->PlayerName, cP->PlayerId, cP->Ping, p->Hits, p->HitMultiplier, MaxHits, Allowance, ((MaxHits * p->HitMultiplier) + Allowance), WeaponName));
						}
						p->Hits = 0;
						p->HitMultiplier = 1;
					}

					const WeaponDefinitionClass *Weapon = Get_Current_Weapon_Definition(PlayerObj);
					if (Weapon && p->CurrWeapon != Weapon)
					{
						p->LastWeapon = p->CurrWeapon;
						p->CurrWeapon = Weapon;
						p->LastActive = Time;
						p->Hits = 0;
						p->HitMultiplier = 1;
					}

					const AmmoDefinitionClass *Ammo = Get_Weapon_Ammo_Definition(Get_Current_Weapon(PlayerObj), true);
					if (Ammo && p->CurrAmmo != Ammo)
					{
						p->LastAmmo = p->CurrAmmo;
						p->CurrAmmo = Ammo;
					}
					delete []WeaponName;
				}
			}
		}
	}
}
RangeRoFDetection rangeRoFDetection;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &rangeRoFDetection;
}
